function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1p2Ftnckt-XZ2pEomfUYDpTqJroxFsDVt124JD8R2l9g"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Save the uploaded paper file (if provided)
    var fileUrl = "";
    var fileStatus = "No file uploaded";

    if (data.paperFile && data.paperFile.data) {
      try {
        // Try to get or create a folder for paper submissions
        var folder;
        try {
          folder = DriveApp.getFolderById("1f2qxBb76sV_CKnX0Rzo8JG4GLshubrn5");
        } catch (folderError) {
          // If folder doesn't exist, create one
          folder = DriveApp.createFolder("AI Days 2025 - Paper Submissions");
          console.log("Created new folder: " + folder.getId());
        }

        var blob = Utilities.newBlob(
          Utilities.base64Decode(data.paperFile.data),
          data.paperFile.type || "application/pdf",
          data.paperFile.name
        );
        var file = folder.createFile(blob);
        fileUrl = file.getUrl();
        fileStatus =
          "File uploaded successfully: " +
          data.paperFile.name +
          " (" +
          (data.paperFile.size / 1024 / 1024).toFixed(2) +
          " MB)";
      } catch (fileError) {
        console.error("File upload error:", fileError);
        fileStatus = "File upload failed: " + fileError.toString();
        // Continue with form submission even if file upload fails
      }
    }

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.paperTitle || "",
      data.authors || "",
      data.affiliation || "",
      data.submissionType || "",
      data.keywords || "",
      data.abstract || "",
      fileUrl || "",
      fileStatus,
      "Submitted", // Status
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "Paper submitted successfully!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in Paper Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Paper submission failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Paper Title | Authors | Affiliation | Submission Type | Keywords | Abstract | Paper File URL | Status

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_PAPER_APPS_SCRIPT_URL in the JavaScript
*/
